using System;
using System.Linq;

class Program
{
    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        int[] strengths = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int Q = int.Parse(Console.ReadLine());

        for (int i = 0; i < Q; i++)
        {
            string[] options = Console.ReadLine().Split();
            int Mi = int.Parse(options[0]);
            int Ji = int.Parse(options[1]);

            int maxRounds = CalculateMaxRounds(N, strengths, Mi, Ji);
            Console.WriteLine(maxRounds);
        }
    }

    static int CalculateMaxRounds(int N, int[] strengths, int Mi, int Ji)
    {
        int maxRounds = 0;

        for (int i = 1; i <= Ji; i++)
        {
            int index1 = (Mi - 1) * (int)Math.Pow(2, i - 1);
            int index2 = (Mi - 1) * (int)Math.Pow(2, i - 1) + (int)Math.Pow(2, i - 1);

            Swap(ref strengths[index1], ref strengths[index2]);
        }

        int rounds = 0;
        while (N > 1)
        {
            N /= 2;
            rounds++;
        }

        return rounds;
    }

    static void Swap(ref int a, ref int b)
    {
        int temp = a;
        a = b;
        b = temp;
    }
}